import 'package:carq_user/HomeAndOrder/model/address_list_response.dart';
import 'package:carq_user/HomeAndOrder/provider/home_screen_provider.dart';
import 'package:carq_user/Localization/localization_constant.dart';
import 'package:carq_user/Theme/colors.dart';
import 'package:carq_user/Theme/theme.dart';
import 'package:carq_user/lang_const.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';

class AddressListTile extends StatefulWidget {
  final bool isSelected;
  final AddressListData address;

  const AddressListTile({super.key, this.isSelected = false, required this.address});

  @override
  State<AddressListTile> createState() => _AddressListTileState();
}

class _AddressListTileState extends State<AddressListTile> {
  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.all(Amount.screenMargin),
      decoration: BoxDecoration(
        color: widget.isSelected == true ? AppColors.primary.withAlpha(50) : AppColors.white,
        borderRadius: AppBorderRadius.k16,
        border: Border.all(
          color: widget.isSelected == true ? AppColors.primary : AppColors.stroke,
        ),
      ),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          Expanded(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                Text(
                  widget.address.type! == 0
                      ? "Home"
                      : widget.address.type! == 1
                          ? "Office"
                          : "Other",
                  style: Theme.of(context).textTheme.titleMedium!.copyWith(
                        color: AppColors.bodyText,
                        fontWeight: FontWeight.bold,
                      ),
                ),
                Text(
                  widget.address.line1!,
                  maxLines: 3,
                  style: Theme.of(context).textTheme.bodyMedium!.copyWith(
                        color: AppColors.subText,
                      ),
                ),
              ],
            ),
          ),
          Consumer<HomeScreenProvider>(
            builder: (context, HomeScreenProvider homeScreenProvider, child) {
              return IconButton(
                icon: homeScreenProvider.deleteAddressLoading
                    ? const SizedBox(child: CircularProgressIndicator(strokeWidth: 2))
                    : const Icon(Icons.delete),
                color: AppColors.warningHigh,
                onPressed: () async {
                  await showDialog(
                      context: context,
                      builder: (context) {
                        return AlertDialog(
                          title: Text(getTranslated(context, LangConst.deleteAddress).toString()),
                          content: Text(
                            getTranslated(context, LangConst.deleteAddressMsg) ?? '',
                            maxLines: 2,
                          ),
                          actions: [
                            TextButton(
                              onPressed: () {
                                Navigator.of(context).pop(false);
                              },
                              child: Text(getTranslated(context, LangConst.cancel).toString()),
                            ),
                            TextButton(
                              onPressed: () {
                                Navigator.of(context).pop(true);
                              },
                              child: Text(
                                getTranslated(context, LangConst.delete).toString(),
                                style: const TextStyle(
                                  color: AppColors.warningHigh,
                                ),
                              ),
                            ),
                          ],
                        );
                      }).then(
                    (value) {
                      if (value == true) {
                        homeScreenProvider.deleteAddress(widget.address.id!);
                      }
                    },
                  );
                },
              );
            },
          ),
          const SizedBox(width: 10),
          Checkbox(
            value: widget.isSelected,
            onChanged: (bool? value) {},
            visualDensity: const VisualDensity(vertical: -4, horizontal: -4),
          ),
        ],
      ),
    );
  }
}
